<?php
/**
 * Plugin Name: Apus Charityheart
 * Plugin URI: http://apusthemes.com/booking/
 * Description: Apus Charityheart is a plugin for Charityheart directory listing theme
 * Version: 1.0.0
 * Author: ApusTheme
 * Author URI: http://apusthemes.com
 * Requires at least: 3.8
 * Tested up to: 4.1
 *
 * Text Domain: apus-charityheart
 * Domain Path: /languages/
 *
 * @package apus-charityheart
 * @category Plugins
 * @author ApusTheme
 */
if ( ! defined( 'ABSPATH' ) ) exit;

if( !class_exists("ApusCharityheart") ){
	
	final class ApusCharityheart{

		private static $instance;

		public static function getInstance() {
			if ( ! isset( self::$instance ) && ! ( self::$instance instanceof ApusCharityheart ) ) {
				self::$instance = new ApusCharityheart;
				self::$instance->setup_constants();

				add_action( 'plugins_loaded', array( self::$instance, 'load_textdomain' ) );

				self::$instance->includes();
			}

			return self::$instance;
		}

		/**
		 *
		 */
		public function setup_constants(){
			// Plugin version
			if ( ! defined( 'APUSCHARITYHEART_VERSION' ) ) {
				define( 'APUSCHARITYHEART_VERSION', '1.0.0' );
			}

			// Plugin Folder Path
			if ( ! defined( 'APUSCHARITYHEART_PLUGIN_DIR' ) ) {
				define( 'APUSCHARITYHEART_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
			}

			// Plugin Folder URL
			if ( ! defined( 'APUSCHARITYHEART_PLUGIN_URL' ) ) {
				define( 'APUSCHARITYHEART_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
			}

			// Plugin Root File
			if ( ! defined( 'APUSCHARITYHEART_PLUGIN_FILE' ) ) {
				define( 'APUSCHARITYHEART_PLUGIN_FILE', __FILE__ );
			}

			// Prefix
			if ( ! defined( 'APUSCHARITYHEART_PREFIX' ) ) {
				define( 'APUSCHARITYHEART_PREFIX', 'apus_charityheart_' );
			}
		}

		public function includes() {
			// cmb2 custom field
			if ( ! class_exists( 'Taxonomy_MetaData_CMB2' ) ) {
				require_once APUSCHARITYHEART_PLUGIN_DIR . 'inc/vendors/cmb2/taxonomy/Taxonomy_MetaData_CMB2.php';
			}

			
			require_once APUSCHARITYHEART_PLUGIN_DIR . 'inc/class-template-loader.php';
			require_once APUSCHARITYHEART_PLUGIN_DIR . 'inc/mixes-functions.php';
			require_once APUSCHARITYHEART_PLUGIN_DIR . 'inc/class-apus-widgets.php';

			apuscharityheart_includes( APUSCHARITYHEART_PLUGIN_DIR . 'inc/taxonomies/*.php' );
			apuscharityheart_includes( APUSCHARITYHEART_PLUGIN_DIR . 'inc/post-types/*.php' );

			add_action( 'widgets_init', array($this, 'widgets_init') );
		}
		/**
		 *
		 */
		public function load_textdomain() {
			// Set filter for ApusCharityheart's languages directory
			$lang_dir = dirname( plugin_basename( APUSCHARITYHEART_PLUGIN_FILE ) ) . '/languages/';
			$lang_dir = apply_filters( 'apuscharityheart_languages_directory', $lang_dir );

			// Traditional WordPress plugin locale filter
			$locale = apply_filters( 'plugin_locale', get_locale(), 'apus-charityheart' );
			$mofile = sprintf( '%1$s-%2$s.mo', 'apus-charityheart', $locale );

			// Setup paths to current locale file
			$mofile_local  = $lang_dir . $mofile;
			$mofile_global = WP_LANG_DIR . '/apus-charityheart/' . $mofile;

			if ( file_exists( $mofile_global ) ) {
				// Look in global /wp-content/languages/apus-charityheart folder
				load_textdomain( 'apus-charityheart', $mofile_global );
			} elseif ( file_exists( $mofile_local ) ) {
				// Look in local /wp-content/plugins/apus-charityheart/languages/ folder
				load_textdomain( 'apus-charityheart', $mofile_local );
			} else {
				// Load the default language files
				load_plugin_textdomain( 'apus-charityheart', false, $lang_dir );
			}
		}

		public function widgets_init() {
			apuscharityheart_includes( APUSCHARITYHEART_PLUGIN_DIR . 'inc/widgets/*.php' );
		}
	}
}

function ApusCharityheart() {
	return ApusCharityheart::getInstance();
}

ApusCharityheart();
