<?php
/**
 * apus charityheart
 *
 * @package    apus-charityheart
 * @author     ApusTheme <apusthemes@gmail.com >
 * @license    GNU General Public License, version 3
 * @copyright  13/06/2016 ApusTheme
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class ApusCharityheart_Post_Type_Give_Forms{

	public static function init() {
		// custom fields
		add_filter( 'cmb2_meta_boxes', array( __CLASS__, 'metaboxes' ) );
	}

	public static function metaboxes( array $metaboxes ) {
		$prefix = APUSCHARITYHEART_PREFIX;
		
		$metaboxes[ $prefix . 'info' ] = array(
			'id'                        => $prefix . 'info',
			'title'                     => __( 'End Time', 'apus-charityheart' ),
			'object_types'              => array( 'give_forms' ),
			'context'                   => 'side',
			'priority'                  => 'low',
			'show_names'                => true,
			'fields'                    => apply_filters( 'apus_charityheart_postype_give_forms_metaboxes_fields_management', array(
				   	array(
		                'id' => $prefix.'endtime',
		                'type' => 'text_date',
		                'name' => esc_html__('End Time', 'charityheart')
		            ),
		            array(
		                'id' => $prefix.'featured',
		                'type' => 'checkbox',
		                'name' => esc_html__('Featured', 'charityheart')
		            )
				)
			)
		);
		return $metaboxes;
	}
	
}

ApusCharityheart_Post_Type_Give_Forms::init();